<?php

$toplam_tutar = $db->query("SELECT sum(toplam_tutar) as toplam_tutar FROM siparis WHERE durum != 6")->fetch(PDO::FETCH_ASSOC);
$komisyon_kazanciniz = $db->query("SELECT sum(alacak) as alacak FROM alacak_verecek")->fetch(PDO::FETCH_ASSOC);

$kendi_kazanciniz = 0;
$query = $db->query("SELECT
					siparis_urun.fiyat,
					siparis_urun.adet,
					siparis_urun.kargo_fiyati
					FROM
					siparis
					INNER JOIN siparis_urun ON siparis.id = siparis_urun.siparis_id
					WHERE
					siparis.durum != 6 AND
					siparis_urun.magaza_id = 0
					");
if($query->rowCount()){
	foreach( $query as $row ){
		$kendi_kazanciniz += ($row['fiyat'] * $row['adet']) + $row['kargo_fiyati'];
	}
}


$bekleyen_odeme = $db->query("SELECT sum(verecek) as verecek FROM alacak_verecek")->fetch(PDO::FETCH_ASSOC);
$yapilan_odemeler = $db->query("SELECT sum(odeme) as odeme FROM magaza_odemeleri")->fetch(PDO::FETCH_ASSOC);

?>

<!--Row-->
<div class="row">
	<div class="col-md-6" style="margin-top: 20px">
		<div class="alert alert-warning" role="alert">Sipariş Detayından Onaylanı Yaparsanız Mağazaya Alacak Ödemesi Yansıtılır.</div>
	</div>
	<div class="col-md-6" style="margin-top: 20px">
		<div class="alert alert-warning" role="alert">Sipariş Detayından Kargoda Yaparsanız Kullancıya Bilgilendirme Maili Gider.</div>
	</div>
	<div class="col-xl-12 col-md-12 col-lg-12">
		<div class="row">
			<div class="col-xl-3 col-lg-3 col-md-12">
				<div class="card bg-gradient-info overflow-hidden text-white">
					<div class="card-body pb-0">
						<p class=" mb-1 ">Toplam Satış Tutarı</p>
						<h2 class="mb-1 font-weight-bold fs-30"><?php echo fiyat($toplam_tutar['toplam_tutar']); ?> TL</h2>
						<span class="mb-1 text-white-50"><span class="dash1-badge">Genel Toplam</span>
					</div>
					<div class="chart-wrapper overflow-hidden">
						<canvas id="area-chart1" class="area-chart chart-dropshadow-dark"></canvas>
					</div>
				</div>
			</div>
			<div class="col-xl-3 col-lg-3 col-md-12">
				<div class="card bg-gradient-danger overflow-hidden text-white">
					<div class="card-body pb-0">
						<p class=" mb-1 ">Komisyon Kazancınız</p>
						<h2 class="mb-1 font-weight-bold fs-30"><?php echo fiyat($komisyon_kazanciniz['alacak']); ?> TL</h2>
						<span class="mb-1 text-white-50"><span class="dash1-badge">Genel Toplam</span>
					</div>
					<div class="chart-wrapper overflow-hidden">
						<canvas id="area-chart2" class="area-chart chart-dropshadow-dark"></canvas>
					</div>
				</div>
			</div>
			<div class="col-xl-3 col-lg-3 col-md-12">
				<div class="card bg-gradient-teal overflow-hidden text-white">
					<div class="card-body pb-0">
						<p class=" mb-1 ">Kendi Ürün Satış Kazancınız</p>
						<h2 class="mb-1 font-weight-bold fs-30"><?php echo fiyat($kendi_kazanciniz); ?> TL</h2>
						<span class="mb-1 text-white-50"><span class="dash1-badge">Genel Toplam</span>
					</div>
					<div class="chart-wrapper overflow-hidden">
						<canvas id="area-chart3" class="area-chart chart-dropshadow-dark"></canvas>
					</div>
				</div>
			</div>
			<div class="col-xl-3 col-lg-3 col-md-12">
				<div class="card bg-gradient-info overflow-hidden text-white">
					<div class="card-body pb-0">
						<p class=" mb-1 ">Bekleyen Mağaza Ödemeleri</p>
						<h2 class="mb-1 font-weight-bold fs-30"><?php echo fiyat($bekleyen_odeme['verecek'] - $yapilan_odemeler['odeme']); ?> TL</h2>
						<span class="mb-1 text-white-50"><span class="dash1-badge">Genel Toplam</span>
					</div>
					<div class="chart-wrapper overflow-hidden">
						<canvas id="area-chart4" class="area-chart chart-dropshadow-dark"></canvas>
					</div>
				</div>
			</div>
		</div>
		<hr class="dash1-hr">
	</div>
</div>

<!--Row-->
<div class="row row-deck">
	<div class="col-xl-12 col-lg-12 col-md-12">
		<div class="card">
			<div class="card-header">
				<div class="card-title">Onay Bekelyen Siparişler</div>
			</div>
			<div class="card-body">
				<div class="table-responsive">
					<table class="table table-bordered text-nowrap" id="example2">
						<thead>
							<tr>
								<th class="wd-15p border-bottom-0">ID</th>
								<th class="wd-15p border-bottom-0">Ad</th>
								<th class="wd-15p border-bottom-0">Soyad</th>
								<th class="wd-15p border-bottom-0">Telefon</th>
								<th class="wd-15p border-bottom-0">Email</th>
								<th class="wd-15p border-bottom-0">Referans Kodu</th>
								<th class="wd-15p border-bottom-0">Ödeme Yöntemi</th>
								<th class="wd-15p border-bottom-0">Toplam Tutar</th>
								<th class="wd-15p border-bottom-0">Sipariş Tarihi</th>
								<th class="wd-15p border-bottom-0">Adres</th>
								<th class="wd-15p border-bottom-0">İşlem</th>
							</tr>
						</thead>
						<tbody>
							<?php
		                      $query = $db->query("SELECT * FROM siparis WHERE durum = 0 ORDER BY id DESC", PDO::FETCH_ASSOC);
		                      if($query->rowCount()){
		                        foreach( $query as $row ){

		                          echo '
		                            <tr>
		                              <td>'.$row['id'].'</td>
		                              <td>'.$row['ad'].'</td>
		                              <td>'.$row['soyad'].'</td>
		                              <td>'.$row['telefon'].'</td>
		                              <td>'.$row['email'].'</td>
		                              <td>'.$row['siparis_key'].'</td>
		                              <td>'.$odeme_yontemi[$row['odeme_yontemi']].'</td>
		                              <td>'.fiyat($row['toplam_tutar']).' TL</td>
		                              <td>'.date('Y-m-d H:i:s',$row['siparis_tarihi']).'</td>
		                              <td>'.$row['adres'].'</td>
		                              <td>
		                                <a href="siparis-detay/'.$row['id'].'" class="badge badge-success" style="margin-right:10px">Detay</span>
		                              </td>
		                            </tr>
		                          ';
		                        }
		                      }else{
		                      		echo '<tr><td colspan="12"><center><h2>Sipariş bulunamadı...</h2></center></td></tr>';
		                      }
		                    ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
<!--End row-->